/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.toma.gunsrpg.common.quests.QuestProperties;
import dev.toma.gunsrpg.common.quests.condition.AbstractQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestCondition;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProviderSerializer;
import dev.toma.gunsrpg.common.quests.condition.QuestConditionProviderType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import dev.toma.gunsrpg.util.properties.IPropertyReader;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class HasAggroConditionProvider
extends AbstractQuestConditionProvider<HasAggroConditionProvider>
implements IQuestCondition {
    private final boolean status;
    private final ITextComponent[] descriptors;

    protected HasAggroConditionProvider(QuestConditionProviderType<HasAggroConditionProvider> type, boolean status) {
        super(type);
        this.status = status;
        this.descriptors = HasAggroConditionProvider.expandWithShortLocalizations(new ITextComponent[]{new TranslationTextComponent(this.getLocalizationString() + ".false"), new TranslationTextComponent(this.getLocalizationString() + ".true")});
    }

    public static HasAggroConditionProvider fromNbt(QuestConditionProviderType<HasAggroConditionProvider> type, CompoundNBT data) {
        return new HasAggroConditionProvider(type, data.func_74767_n("status"));
    }

    @Override
    public ITextComponent getDescriptor(boolean shortDesc) {
        int i;
        int n = i = this.status ? 1 : 0;
        if (shortDesc) {
            i |= 2;
        }
        return this.descriptors[i];
    }

    @Override
    public boolean isValid(PlayerEntity player, IPropertyReader reader) {
        LivingEntity entity = reader.getProperty(QuestProperties.ENTITY);
        if (entity instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)entity;
            LivingEntity target = mobEntity.func_70638_az();
            return this.status ? target == player : target == null;
        }
        return true;
    }

    @Override
    public HasAggroConditionProvider makeConditionInstance() {
        return this;
    }

    @Override
    public IQuestConditionProvider<?> getProviderType() {
        return this;
    }

    @Override
    public void saveInternalData(CompoundNBT nbt) {
        nbt.func_74757_a("status", this.status);
    }

    public static final class Serializer
    implements IQuestConditionProviderSerializer<HasAggroConditionProvider> {
        @Override
        public HasAggroConditionProvider deserialize(QuestConditionProviderType<HasAggroConditionProvider> conditionType, JsonElement data) {
            JsonObject object = JsonHelper.asJsonObject(data);
            boolean status = JSONUtils.func_151209_a((JsonObject)object, (String)"aggro", (boolean)true);
            return new HasAggroConditionProvider(conditionType, status);
        }
    }
}

